<?php
include_once 'includes/processes.php';
require_once 'PHPExcel/PHPExcel.php';
require_once 'PHPExcel/PHPExcel/IOFactory.php';
$Process = new Login_Process;

$pageLink = basename($_SERVER['REQUEST_URI']);
$Process->check_status($pageLink);

$ref_number = filter_var($_GET['ref_number'], FILTER_SANITIZE_STRING);
$category = filter_var($_GET['category'], FILTER_SANITIZE_STRING);
$startDate = filter_var($_GET['startDate'], FILTER_SANITIZE_STRING);
$endDate = filter_var($_GET['endDate'], FILTER_SANITIZE_STRING);
$phone_number = filter_var($_GET['phone_number'], FILTER_SANITIZE_STRING);
$Logstatus = filter_var($_GET['Logstatus'], FILTER_SANITIZE_STRING);
$opened_by = filter_var($_GET['opened_by'], FILTER_SANITIZE_STRING);
$closed_by = filter_var($_GET['closed_by'], FILTER_SANITIZE_STRING);
//$getExcel = filter_var($_GET['getExcel'], FILTER_SANITIZE_STRING);

$dbLink = $Process->connect_db();
$sql  = "SELECT * FROM apl_case_log where 1=1 ";
if(!empty($ref_number)) { $sql  .= "and log_id = '$ref_number' "; }
if(!empty($category) && $category!="All") { $sql  .= "and  log_category = '$category' "; }
if(!empty($startDate)) { $sql  .= "and opened_date between '$startDate' and '$endDate' "; }
if(!empty($phone_number)) { $sql  .= "and caller_phone = '$phone_number' "; }
if(!empty($Logstatus) && $Logstatus!="All") { $sql  .= "and log_status = '$Logstatus' "; }
if(!empty($opened_by) && $opened_by!="All") { $sql  .= "and  open_agent_id  = '$opened_by' "; }
if(!empty($closed_by) && $closed_by!="All") { $sql  .= "and  close_agent_id  = '$closed_by' "; }
$sql  .= "and log_status !='Empty' order by  time_opened ";

$runQ = $Process->RunQuery($sql,$dbLink);
$num_rows = $runQ->rowCount();

//comment line below to see sql built;
//echo $sql;

	echo "<div class=\"portlet\">
            <div class=\"portlet-header\">
              <h3>
                <i class=\"fa fa-th\"></i>
                Search Result <span style=\"color:red;\">[$num_rows Record(s) Found]</span>
              </h3>";
			  if($num_rows > 0) {
				//check if user want to generte excel file
				//if($getExcel=="Yes") {
					//generate call log excel file
					$excelFile = $Process->generateExcel_Case_Log($sql);
					  echo"<ul class=\"portlet-tools pull-right\">
					   <li>
						<a href=\"exports/$excelFile\" target=\"_blank\" data-toggle=\"tooltip\" title=\"Download Excel\" class=\"btn btn-sm btn-info\">
							<i class=\"fa fa-download\"></i> Download Excel
						  </a>
					   </li>
					  </ul>	";
				//}

			  }
            echo"</div> <!-- /.portlet-header -->
            <div class=\"portlet-content\" style=\"font-size:11px\">  ";
	if($num_rows > 0){
		echo"<table
		class=\"table table-striped table-bordered table-hover\"
		data-provide=\"datatable\"
		data-display-rows=\"10\"
		data-paginate=\"true\"
		data-info=\"true\"
		data-search=\"true\"
		data-length-change=\"true\"
	  >
		  <thead>
			<tr>
				<th class=\"tbli_headder\"># Ref</th>
				<th class=\"tbli_headder\">Case Category</th>
				<th class=\"tbli_headder\">Caller Name (PNR)</th>
				<th class=\"tbli_headder\">Caller Phone </th>
				<th class=\"tbli_headder\">Case Description</th>
				<th class=\"tbli_headder\">Status</th>
				<th class=\"tbli_headder\">Opened by / Closed by</th>
				<th class=\"tbli_headder\">Date Opend / Closed</th>
				<th>Action</th>
			</tr>
		  </thead>
		  <tbody>";
		$sn = 0;
		while($callog = $runQ->fetch()) {
			$sn += 1;
			$id 		= $callog->log_id;
			$category	= $callog->log_category;
			$callerName	= $callog->caller_name;
			$phone 		= $callog->caller_phone;
			$casePNR		= $callog->case_pnr;
			$caseDesc	= $Process->limit_words($callog->case_description,5);
			$logStatus	= $callog->log_status;
			$openAgent	= $callog->open_agent_id;
			$closeAgent	= $callog->close_agent_id;
			$opened		= date("d-m-Y",$callog->time_opened);
			$closed		= date("d-m-Y",$callog->time_closed);

			//getusers
			$getOpenAgentData = $Process->getEmployeeInfo($openAgent);
			$openAgentName = $getOpenAgentData->firstname;

			$getCloseAgentData = $Process->getEmployeeInfo($closeAgent);
			$closeAgentName = $getCloseAgentData->firstname;

			echo"<tr>
					<td><a href=\"open-call-log.php?lid=$id\">#$id</a></td>
					<td>$category</td>
					<td>$callerName";
					if($casePNR!=""){ echo " ($casePNR)";}
					echo"</td>
					<td>$phone </td>
					<td>$caseDesc...</td>
					<td><span class=\"label ";
					switch($logStatus) {
							case "Open":
							echo"label-danger";
							break;
							case "Closed":
							echo"label-success";
							break;
						}
					echo"\">$logStatus</span></td>
					<td>$openAgentName / ";
					if($closeAgent==0) {echo"still open";}else{echo $closeAgentName;}
					echo"</td>
					<td>$opened / ";
					if($callog->time_closed==0) {echo"still open";}else{echo $closed;}
					echo"</td>
					<td>
						<a href=\"open-call-log.php?lid=$id\"><span class=\"add-on small-size\" title=\"open log\"><i class=\"fa fa-phone\"></i> view</span></a>
					</td>
				 </tr>";
		}
		echo "</tbody></table>";
	}else {
		echo'<div class="alert alert-danger" style="padding:5px"><strong>No Record Found</strong></div>';
	}
echo"</div>";
$dbLink = null;
?>
