<?php
include_once 'includes/processes.php';
$Process = new Login_Process;
$Process->check_status($_SERVER['SCRIPT_NAME']);

$stationID = filter_var($_GET['station_id'], FILTER_SANITIZE_STRING);
$startDate = filter_var($_GET['startDate'], FILTER_SANITIZE_STRING);
$endDate = filter_var($_GET['endDate'], FILTER_SANITIZE_STRING);
$severity = filter_var($_GET['severity'], FILTER_SANITIZE_STRING);
$tstatus = filter_var($_GET['tstatus'], FILTER_SANITIZE_STRING);
$assigned = filter_var($_GET['assigned'], FILTER_SANITIZE_STRING);

$dbLink = $Process->connect_db();
$sql  = "SELECT * FROM apl_tickets where 1=1 ";
if(!empty($startDate)) { $sql  .= "and opened_date between '$startDate' and '$endDate' "; }
if(!empty($severity) && $severity!="All") { $sql  .= "and severity = '$severity' "; }
if(!empty($tstatus) && $tstatus!="All") { $sql  .= "and status = '$tstatus' "; }
if(!empty($assigned) && $assigned!="All") { $sql  .= "and assigned = '$assigned' "; }
if(!empty($stationID) && $stationID!="All") { $sql  .= "and station_id = '$stationID' "; }
$sql  .= "order by time_created";

$runQ = $Process->RunQuery($sql,$dbLink);
$num_rows = $runQ->rowCount();

//comment line below to see sql built;
//echo $sql;
	//echo'<div class="alert alert-info" style="padding:5px"><strong>'.$num_rows.' Record(s) Found</strong></div>';
if($num_rows > 0){
	echo "<table 
		class=\"table table-striped table-bordered table-hover\" 
		data-provide=\"datatable\" 
		data-display-rows=\"10\"
		data-paginate=\"true\"
		data-info=\"true\"
		data-search=\"true\"
		data-length-change=\"true\"
	  >
		  <thead>
			<tr>
			  <th>SN</th>
			  <th>Ref</th>
			  <th>Subject</th>
			  <th>Severity</th>
			  <th>Status</th>
			  <th>Assigned</th>
			  <th>Date Opened / Resolved</th>
			  <th>Action</th>
			</tr>
		  </thead>
		  <tbody>";
	$sn = 0;
	while($ticket = $runQ->fetch()) {
		$sn += 1;
		$id 			= $ticket->ticket_id;
		$tRef 			= $ticket->ticket_ref;
		$subject 		= $ticket->ticket_subject;				
		$opened 		= $ticket->opened_date;
		$closed	 		= $ticket->close_date;
		$status 		= $ticket->status;
		$severity 		= $ticket->severity;
		$assigned 		= $ticket->assigned;
		
		$empData = $Process->getEmployeeInfo($assigned);
		$empName = $empData->fullname;
		
		echo"<tr>
				<td>$sn</td>
				<td>ATT$tRef-";
				switch($severity) {
					case "Low Level":
					echo"0";
					break;
					case "Normal Level":
					echo"1";
					break;
					case "High Level":
					echo"2";
					break;
				}
				echo"</td>
				<td><a href=\"ticket-details.php?tid=$id\" title=\"$subject\" style=\"text-decoration:none;\">";
					echo $Process->limit_words($ticket->ticket_subject,5);
				echo"...</a></td>
				<td><span class=\"label ";
					switch($severity) {
							case "Low Level":
							echo"label-info";
							break;
							case "Normal Level":
							echo"label-warning";
							break;
							case "High Level":
							echo"label-danger";
							break;
						}
							echo"\">$severity</span></td>									
				<td><div class=\"label ";
				if($status=="Closed") { echo"label-success"; }elseif($status=="Open"){ echo"label-danger"; }elseif($status=="In Progress"){ echo"label-warning"; }
				echo"\"> $status Ticket</div></td>
				<td>$empName</td>
				<td>$opened / ";
				if($closed=="0"){ echo "na"; }else{ echo date("d M, Y: h:ma",$ticket->close_date); } 
				echo"</td>
				<td>
					<a href=\"ticket-details.php?tid=$id\" title=\"View Details\"><span class=\"add-on small-size\"> <i class=\"fa fa-folder-o\"></i></span></a>
				</td>
			  </tr>";
	}
	echo "</tbody></table>";
}
$dbLink = null;
?>