<?php

	//DEVELOPED BY IBRAHIM HARUNA.
	//MD(CEO) JARSOFT ICT SOLUTIONS LIMITED
	
	class SMS
	{
		
		private $username ;
		private $password ;
		
		private $url ;
		private $port ;
		
		private $error_codes;
		private $senderid;
		
		private $result;
		
		public function __construct($senderid,$user="cyon",$pass="Cyon1234", 
									$url="http://www.jarsoftbulksms.com/components/com_spc/smsapi.php",
									$port="80")
		{
			$this->username = $user;
			$this->password = $pass;
			$this->url = $url;
			$this->port = $port;
			$this->senderid = $senderid;
			$this->result = array();	
			$this->error_codes = array(
						 2904 => "SMS Sending Failed",
						 2905 => "Invalid username/password combination",
						 2906 => "Credit exhausted",
						 2907 => "Gateway unavailable",
						 2908 => "Invalid schedule date format",
						 2909 => "Unable to schedule",
						 2910 => "Username is empty",
						 2911 => "Password is empty",
						 2912 => "Recipient is empty",
						 2913 => "Message is empty",
						 2914 => "Sender is empty",
						 2915 => "One or more required fields are empty"
						 
						 );		
		}
		
		public function __destruct()
		{
			$this->username = "";
			$this->password = "";
			$this->url = "";
			$this->port = "";
			$this->error_codes = null;
		}
		
		private function send_message ( $post_body ) 
		{
			/*
			 * Do not supply $post_fields directly as an argument to CURLOPT_POSTFIELDS,
			 * despite what the PHP documentation suggests: cUrl will turn it into in a
			 * multipart formpost, which is not supported:
			*/
			
			$url = "";
			$url .= $this->url.'?'.$post_body;
			
	
			$ch = curl_init();
			curl_setopt ( $ch, CURLOPT_URL, $url );
			curl_setopt ( $ch, CURLOPT_PORT, $this->port );
			curl_setopt ( $ch, CURLOPT_HTTPGET, true );
			curl_setopt ( $ch, CURLOPT_RETURNTRANSFER, 1 );
			//curl_setopt ( $ch, CURLOPT_POSTFIELDS, $post_body );
			// Allowing cUrl funtions 20 second to execute
			curl_setopt ( $ch, CURLOPT_TIMEOUT, 20 );
			curl_setopt ( $ch, CURLOPT_FRESH_CONNECT, true );
			// Waiting 20 seconds while trying to connect
			curl_setopt ( $ch, CURLOPT_CONNECTTIMEOUT, 20 );
	
			$response_string = curl_exec( $ch );
			$curl_info = curl_getinfo( $ch );
			
			//echo $url;
			
			//echo print_r($curl_info);
			//echo"<br> response:<br>  ";
			//echo print_r($response_string);
			
			//echo $response_string;
	
			$sms_result = array();
			$sms_result['success'] = "OK";
			$sms_result['details'] = '';
			$sms_result['transient_error'] = 0;
			$sms_result['http_status_code'] = $curl_info['http_code'];
			$sms_result['api_status_code'] = '';
			$sms_result['api_message'] = '';
			$sms_result['api_batch_id'] = '';
	
			if ( $response_string == FALSE ) {
				$sms_result['details'] .= "cURL error: " . curl_error( $ch ) . "\n";
			} elseif ( $curl_info[ 'http_code' ] != 200 ) {
				$sms_result['transient_error'] = 1;
				$sms_result['details'] .= "Error: non-200 HTTP status code: " . $curl_info[ 'http_code' ] . "<br>";
				$sms_result['details'] .= 'Error: Message Not Sent SuccessFully!';
			}
			else 
			{					
				$status_code = $response_string;
				$sms_result['api_status_code'] = $status_code;
				@$sms_result['details'] .= (substr($response_string,0,2) == "OK") ? "Message Sent Successfully!" : 
				"Error sending: status code '$status_code' description '".$this->error_codes[intval($status_code)]."'";	
				@$sms_result['api_message'] = (substr($response_string,0,2) == "OK") ? "Message Sent SuccessFully!" : $this->error_codes[intval($status_code)];
				
			}
			curl_close( $ch );
	
			return $sms_result;
		}
		
		private function make_stop_dup_id() 
		{
			return 0;
		}
		
		function sendSMS($message, $phoneNumbers)
		{
			$smsSent = false;
			$recipients = "";
			if(strpos($phoneNumbers,",")===FALSE)
			{
				$recipients = $this->processNumbers($phoneNumbers);				
			}
			else
			{
				$recipients = $this->regenNumList($phoneNumbers);				
			}
			
			$post_body = $this->normal_sms( $message, $recipients );
			
			$this->result = $this->send_message( $post_body );
						
			if( substr($this->result['api_status_code'],0,2) =="OK" ) 
			{
				$smsSent = true;				
			}
			else 
			{
				$smsSent = false;
			}
			
			return $smsSent;
		}
		
		function getNoticeDisplay()
		{
			$output = "";
			if( substr($this->result['api_status_code'],0,2) == "OK" ) {
				//print_ln( formatted_server_response( $result ) );			
				$output = "<div class=\"alert alert-block alert-info\">
							<a href=\"#\" class=\"close\" data-dismiss=\"alert\">&times;</a>
							<p>&nbsp;".trim($this->result['details'])."</p></div>";
				//echo $output;
				
			}
			else {
				//print_ln( formatted_server_response( $result ) );
				$output = "<div class=\"alert alert-block\">
						<a href=\"#\" class=\"close\" data-dismiss=\"alert\">&times;</a>
						<p>&nbsp;".trim($this->result['details'])."</p></div>";
				//echo $output;
			}
			return $output;
		}
		
		function getNoticeString()
		{
			$output = trim($this->result['details']);			
			return $output;
		}
		
		private function make_post_body($post_fields) 
		{
			$stop_dup_id = $this->make_stop_dup_id();
			if ($stop_dup_id > 0) {
				$post_fields['stop_dup_id'] = $this->make_stop_dup_id();
			}
			$post_body = '';
			foreach( $post_fields as $key => $value ) {
				$post_body .= urlencode( $key ).'='.urlencode( $value ).'&';
			}
			$post_body = rtrim( $post_body,'&' );
	
			return $post_body;
		}
		
		private function normal_sms ( $message, $recipient ) 
		{
			$post_fields = array (
				'username' => $this->username,
				'password' => $this->password,
				'message'  => $message,
				'recipient'   => $recipient,
				'sender'   => $this->senderid
			);
	
			return $this->make_post_body($post_fields);
		}
		
		private function regenNumList($num)
		{
			$arrNum = explode(",",$num);
			$strArrValues = "";
			
			foreach($arrNum as $key => $value)
			{
				$strArrValues .= $this->processNumbers($value).",";			
				
			}
			
			$strArrValues = substr($strArrValues,0,strlen($strArrValues)-1);
			//echo $strArrValues;
			return $strArrValues;		
		}
		
		private function processNumbers($phone)
		{        
			$num = "";
			
			if(strlen($phone) == 11)
			{
				$num .= "234".trim(substr($phone,1,10));
				
	
			}
			else if(strlen($phone) > 11 && strlen($phone) <= 13)
			{
				$num .= $phone;
			}
			else
			{
				$num = $phone;
			}  
			
			return $num;
			
		}
		
		
	}
	
	//$sms = new SMS("SenderID","username","pass");
	
	//$sms->sendSMS("This is a test message","08034893586,07065138899");
	
	//echo $sms->getNoticeDisplay();
	
	//echo $sms->getNoticeString();









?>