<?php
include_once 'includes/processes.php';
require_once 'PHPExcel/PHPExcel.php';
require_once 'PHPExcel/PHPExcel/IOFactory.php';
$Process = new Login_Process;

$pageLink = basename($_SERVER['REQUEST_URI']);
$Process->check_status($pageLink);

$employeeData = $Process->getEmployeeInfo($_SESSION['userid']);
$deptData = $Process->getDepartmentInfo($employeeData->department);
$desigData = $Process->getDesignationInfo($employeeData->designation);
?>
<!DOCTYPE html>
<!--[if lt IE 7]>      <html class="no-js lt-ie9 lt-ie8 lt-ie7"> <![endif]-->
<!--[if IE 7]>         <html class="no-js lt-ie9 lt-ie8"> <![endif]-->
<!--[if IE 8]>         <html class="no-js lt-ie9"> <![endif]-->
<!--[if gt IE 8]><!--> <html class="no-js"> <!--<![endif]-->
<head>
  <title>Case Logger - APL Portal</title>

  <meta charset="utf-8">
  <meta name="description" content="">
  <meta name="viewport" content="width=device-width">

  <link rel="stylesheet" href="http://fonts.googleapis.com/css?family=Open+Sans:400italic,600italic,700italic,400,600,700">
  <link rel="stylesheet" href="http://fonts.googleapis.com/css?family=Oswald:400,300,700">
  <link rel="stylesheet" href="./css/font-awesome.min.css">
  <link rel="stylesheet" href="./js/libs/css/ui-lightness/jquery-ui-1.9.2.custom.min.css">
  <link rel="stylesheet" href="./css/bootstrap.min.css">

   <!-- Plugin CSS -->
  <link rel="stylesheet" href="./js/plugins/magnific/magnific-popup.css">
  <link rel="stylesheet" href="./js/plugins/datepicker/datepicker.css">
  <link rel="stylesheet" href="./js/plugins/timepicker/bootstrap-timepicker.css">
  <link rel="stylesheet" href="./js/plugins/icheck/skins/minimal/blue.css">

  <!-- App CSS -->
  <link rel="stylesheet" href="./css/target-admin.css">
  <link rel="stylesheet" href="./css/custom.css">


  <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!--[if lt IE 9]>
  <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
  <script src="https://oss.maxcdn.com/libs/respond.js/1.3.0/respond.min.js"></script>
  <![endif]-->
  <script>

function openModal() {
	document.getElementById('modal').style.display = 'block';
}

function closeModal() {
    document.getElementById('modal').style.display = 'none';
}

function runLogReport() {
	openModal();
	var ref_number = document.getElementById("searchCallLog").elements.namedItem("ref_number").value;
	var category = document.getElementById("searchCallLog").elements.namedItem("category").value;
	var startDate = document.getElementById("searchCallLog").elements.namedItem("startDate").value;
	var endDate = document.getElementById("searchCallLog").elements.namedItem("endDate").value;
	var phone_number = document.getElementById("searchCallLog").elements.namedItem("phone_number").value;
	var Logstatus = document.getElementById("searchCallLog").elements.namedItem("Logstatus").value;
	var opened_by = document.getElementById("searchCallLog").elements.namedItem("opened_by").value;
	var closed_by = document.getElementById("searchCallLog").elements.namedItem("closed_by").value;

    //if (str == "") {
    //    document.getElementById("txtHint").innerHTML = "";
    //    return;
   // } else {
        if (window.XMLHttpRequest) {
            // code for IE7+, Firefox, Chrome, Opera, Safari
            xmlhttp = new XMLHttpRequest();
        } else {
            // code for IE6, IE5
            xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
        }
        xmlhttp.onreadystatechange = function() {
            if (this.readyState == 4 && this.status == 200) {
				closeModal();
                document.getElementById("searchResult").innerHTML = this.responseText;
            }
        };
        xmlhttp.open("GET","search-case-log.php?ref_number="+ref_number+"&category="+category+"&startDate="+startDate+"&endDate="+endDate+"&phone_number="+phone_number+"&Logstatus="+Logstatus+"&opened_by="+opened_by+"&closed_by="+closed_by,true);
        xmlhttp.send();
    //}
}
</script>
<style>
body, html {
    margin:0;
    padding;
    height:100%
}

#content {
    padding:25px;
}

#fade {
    display: none;
    position:absolute;
    top: 0%;
    left: 0%;
    width: 100%;
    height: 100%;
    background-color: #ababab;
    z-index: 1001;
    -moz-opacity: 0.8;
    opacity: .70;
    filter: alpha(opacity=80);
}

#modal {
    display: none;
    position: absolute;
    top: 45%;
    left: 45%;
    width: 64px;
    height: 64px;
    padding:10px 5px 0px;
    border: 3px solid #ababab;
    box-shadow:1px 1px 10px #ababab;
    border-radius:20px;
    background-color: white;
    z-index: 1002;
    text-align:center;
}

</style>
</head>

<body>

<?php include'includes/header.php'; ?>

<div class="container">

  <div class="content">

    <div class="content-container">



      <div class="content-header">
        <h2 class="content-header-title">Case Logger</h2>
        <ol class="breadcrumb">
          <li><a href="./">Home</a></li>
          <li class="active">Case Logger</li>
        </ol>
      </div> <!-- /.content-header -->



      <div class="row">

        <div class="col-md-12">
		<?php
			if(isset($_GET['st'])){
				if($_GET['st']==1){
					echo"<div class=\"alert alert-success\" style=\"padding:5px\"><i class=\"fa fa-check\"></i> Case Closed</div>";
				}
			}
		?>
		</div>
        <div class="col-md-12">
		<?php 	if(in_array("log_case",$_SESSION['privileges'])): ?>
		<a href="new-case-log.php?mode=1" class="btn btn-md btn-success"><i class="fa fa-ticket"></i> New Case</a>
		<br />
		<br />
		<?php endif; ?>
		<div class="portlet">
            <div class="portlet-header">
              <h3>
                <i class="fa fa-folder-open"></i>
                Open Case Log
              </h3>
            </div> <!-- /.portlet-header -->
            <div class="portlet-content" style="font-size:11px">
				<?php
					if(in_array("log_case",$_SESSION['privileges'])) {
						$Process->getOpenCaseLogs();
					}elseif(in_array("crc_case_resolver",$_SESSION['privileges'])) {
						$Process->getDeptCaseLogs("Commercial");
					}elseif(in_array("bd_case_resolver",$_SESSION['privileges'])) {
						$Process->getDeptCaseLogs("Busines Dev");
					}elseif(in_array("it_case_resolver",$_SESSION['privileges'])) {
						$Process->getDeptCaseLogs("IT");
					}elseif(in_array("account_case_resolver",$_SESSION['privileges'])) {
						$Process->getDeptCaseLogs("Accounts");
					}elseif(in_array("view_case",$_SESSION['privileges'])){
            $Process->getViewCaseLogs();
          }
				?>
            </div> <!-- /.portlet-content -->

        </div> <!-- /.portlet -->


        </div> <!-- /.col -->

		<?php if(in_array("log_case",$_SESSION['privileges'])): ?>
		<div class="col-md-12">
		 <div class="portlet">
            <div class="portlet-header">
              <h3>
                <i class="fa fa-search"></i>
                Log Advance Search
              </h3>
            </div> <!-- /.portlet-header -->
            <div class="portlet-content">
				<form name="searchCallLog" id="searchCallLog" method="get">
				<table class="table table-striped table-bordered table-hover" >
					<tbody>
						<tr>
						  <td>
							<input class="form-control" name="ref_number" type="text" placeholder="Ref Number">
						  </td>
						  <td>
							<select class="form-control" name="category" id="category">
								<option value="All">--category--</option>
								<option value="Refund">Refund</option>
                <option value="Debit">Debit</option>
								<option value="Name Change">Name Change</option>
								<option value="Date Change">Date Change</option>
      					<option value="Distruption">Distruption</option>
      					<option value="Open Ticket">Open Ticket</option>
      					<option value="Reservation">Reservation</option>
      					<option value="Missing Item">Missing Item</option>
								<option value="Website not Opening">Website not Opening</option>
								<option value="Unable to pay online">Unable to pay online</option>
								<option value="Unclear Calls">Unclear Calls</option>
								<option value="Other Issues">Other Issues</option>
							</select>
						  </td>
						  <td>
							<div id="dp-ex-1" class="input-group date"  data-auto-close="true"  data-date-autoclose="true">
								<input class="form-control" name="startDate" type="text" placeholder="Start Date">
								<span class="input-group-addon"><i class="fa fa-calendar"></i></span>
							</div>
							<span class="help-block">yyyy-mm-dd</span>
						  </td>
						  <td>
							<div id="dp-ex-2" class="input-group date"  data-auto-close="true"  data-date-autoclose="true">
								<input class="form-control" name="endDate" type="text" placeholder="End Date">
								<span class="input-group-addon"><i class="fa fa-calendar"></i></span>
							</div>
							<span class="help-block">yyyy-mm-dd</span>
						  </td>
						  <td>
							<input class="form-control" name="phone_number" type="text" placeholder="Phone Number">
						  </td>
						  <td>
							<select class="form-control" name="Logstatus">
								<option value="All">-- status --</option>
								<option value="Open">Open</option>
								<option value="Closed">Closed</option>
							</select>
						  </td>
						  <td>
							<select class="form-control" name="opened_by">
								<option value="All">--opened by--</option>
								<?php $Process->listCallLogAgent("open"); ?>
							</select>
						  </td>
						  <td>
							<select class="form-control" name="closed_by">
								<option value="All">--close by--</option>
								<?php $Process->listCallLogAgent("close"); ?>
							</select>
						  </td>
						  <td>
							<button type="button" name="run_report" onclick="runLogReport()" class="btn btn-primary"><i class="fa fa-search"></i></button>
						  </td>
						</tr>
					</tbody>
				</table>
				</form>


            </div> <!-- /.portlet-content -->

          </div> <!-- /.portlet -->

			<div id="searchResult"><!-- Results are displayed here --></div>
			<div id="fade"></div>
			<div id="modal">
				<img id="loader" src="img/loading.gif" />
			</div>

			<div class="portlet">
            <div class="portlet-header">
              <h3>
                <i class="fa fa-folder"></i>
                All Case Log
              </h3>
            </div> <!-- /.portlet-header -->
            <div class="portlet-content" style="font-size:11px">
				<?php
					$Process->getCaseLogs();
				?>
            </div> <!-- /.portlet-content -->

        </div> <!-- /.portlet -->

        </div> <!-- /.col -->
		<?php endif; ?>

      </div> <!-- /.row -->








    </div> <!-- /.content-container -->

  </div> <!-- /.content -->

</div> <!-- /.container -->
	<?php include"includes/footer.php"; ?>



   <div id="basicModal" class="modal fade">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3 class="modal-title"><i class="fa fa-ticket"></i> New Requisition</h3>
      </div>
	  <form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="post">
		<div class="modal-body">
			<div class="row">
				<div class="col-sm-12">
					<div class="form-group col-sm-12">
						<label for="reason">Reason For Request</label>
						<input type="text" id="reason" class="form-control">
					</div>
					</div> <!-- /.col -->
			</div>
			<div class="row">
				<div class="col-sm-4">
					<div class="form-group col-sm-12">
						<label for="item_desc">Item Description</label>
						<input type="text" id="item_desc" name="item_desc[]" class="form-control">
					</div>
				</div>
				<div class="col-sm-4">
					<div class="form-group col-sm-12">
						<label for="item_qty">Item quantity</label>
						<input type="number" id="item_qty" name="item_qty[]" class="form-control">
					</div>
				</div>
				<div class="col-sm-4">
					<div class="form-group col-sm-12">
						<label for="item_remark">Remarks</label>
						<input type="text" id="item_remark" name="item_remark[]" class="form-control">
					</div>
				</div>

				<div id="dynamicInputs"></div>

				<div class="col-md-12">
				<a href="javascript:;" class="btn btn-info btn-lg btn-xs pull-right" type="button" onclick="addItem('dynamicInputs');">Add Item <i class="fa fa-plus"></i></a>
				</div>
			</div>
		<div class="modal-footer">
			<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
			<button type="submit" name="request" class="btn btn-primary">Make Request</button>
		</div>
	  </form>
    </div><!-- /.modal-content -->
  </div><!-- /.modal-dialog -->
</div><!-- /.modal -->

 <script src="./js/libs/jquery-1.10.1.min.js"></script>
  <script src="./js/libs/jquery-ui-1.9.2.custom.min.js"></script>
  <script src="./js/libs/bootstrap.min.js"></script>

  <!--[if lt IE 9]>
  <script src="./js/libs/excanvas.compiled.js"></script>
  <![endif]-->

  <!-- Plugin JS -->
  <script src="./js/plugins/datatables/jquery.dataTables.min.js"></script>
  <script src="./js/plugins/datatables/DT_bootstrap.js"></script>
  <script src="./js/plugins/tableCheckable/jquery.tableCheckable.js"></script>
  <script src="./js/plugins/icheck/jquery.icheck.min.js"></script>
  <script src="./js/plugins/select2/select2.js"></script>
  <script src="./js/plugins/datepicker/bootstrap-datepicker.js"></script>
  <script src="./js/plugins/timepicker/bootstrap-timepicker.js"></script>

  <!-- App JS -->
  <script src="./js/target-admin.js"></script>
<!-- Plugin JS -->
  <script src="./js/demos/form-extended.js"></script>

</body>
</html>
