<?php
include_once 'includes/processes.php';
$Process = new Login_Process;
$pageLink = basename($_SERVER['REQUEST_URI']);
$Process->check_status($pageLink);

$addTicket = $Process->addTicket($_POST,$_POST['open_ticket']);
$roleData = $Process->getAccessRoleInfo($_SESSION['access']);
$privileges = explode(",",$roleData->privileges);
?>
<!DOCTYPE html>
<!--[if lt IE 7]>      <html class="no-js lt-ie9 lt-ie8 lt-ie7"> <![endif]-->
<!--[if IE 7]>         <html class="no-js lt-ie9 lt-ie8"> <![endif]-->
<!--[if IE 8]>         <html class="no-js lt-ie9"> <![endif]-->
<!--[if gt IE 8]><!--> <html class="no-js"> <!--<![endif]-->
<head>
  <title>Tickets - APL Portal</title>

  <meta charset="utf-8">
  <meta name="description" content="">
  <meta name="viewport" content="width=device-width">

  <link rel="stylesheet" href="http://fonts.googleapis.com/css?family=Open+Sans:400italic,600italic,700italic,400,600,700">
  <link rel="stylesheet" href="http://fonts.googleapis.com/css?family=Oswald:400,300,700">
  <link rel="stylesheet" href="./css/font-awesome.min.css">
  <link rel="stylesheet" href="./js/libs/css/ui-lightness/jquery-ui-1.9.2.custom.min.css">
  <link rel="stylesheet" href="./css/bootstrap.min.css">

  <!-- Plugin CSS -->
  <link rel="stylesheet" href="./js/plugins/magnific/magnific-popup.css">
  <link rel="stylesheet" href="./js/plugins/datepicker/datepicker.css">
  <link rel="stylesheet" href="./js/plugins/timepicker/bootstrap-timepicker.css">
  <link rel="stylesheet" href="./js/plugins/icheck/skins/minimal/blue.css">

  <!-- App CSS -->
  <link rel="stylesheet" href="./css/target-admin.css">
  <link rel="stylesheet" href="./css/custom.css">


  <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!--[if lt IE 9]>
  <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
  <script src="https://oss.maxcdn.com/libs/respond.js/1.3.0/respond.min.js"></script>
  <![endif]-->
<script>

function openModal() {
	document.getElementById('modal').style.display = 'block';
	document.getElementById('fade').style.display = 'block';
}

function closeModal() {
    document.getElementById('modal').style.display = 'none';
    document.getElementById('fade').style.display = 'none';
}

function runTicketReport() {
	openModal();
	var station_id = document.getElementById("serchTicket").elements.namedItem("station_id").value;
	var startDate = document.getElementById("serchTicket").elements.namedItem("startDate").value;
	var endDate = document.getElementById("serchTicket").elements.namedItem("endDate").value;
	var severity = document.getElementById("serchTicket").elements.namedItem("severity").value;
	var tstatus = document.getElementById("serchTicket").elements.namedItem("tstatus").value;
	var assigned = document.getElementById("serchTicket").elements.namedItem("assigned").value;


    //if (str == "") {
    //    document.getElementById("txtHint").innerHTML = "";
    //    return;
   // } else {
        if (window.XMLHttpRequest) {
            // code for IE7+, Firefox, Chrome, Opera, Safari
            xmlhttp = new XMLHttpRequest();
        } else {
            // code for IE6, IE5
            xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
        }
        xmlhttp.onreadystatechange = function() {
            if (this.readyState == 4 && this.status == 200) {
				closeModal();
                document.getElementById("SearchResults").innerHTML = this.responseText;
            }
        };
        xmlhttp.open("GET","ticket-search.php?station_id="+station_id+"&startDate="+startDate+"&endDate="+endDate+"&severity="+severity+"&tstatus="+tstatus+"&assigned="+assigned,true);
        xmlhttp.send();
    //}
}
</script>
<style>
body, html {
    margin:0;
    padding;
    height:100%
}

#content {
    padding:25px;
}

#fade {
    display: none;
    position:absolute;
    top: 0%;
    left: 0%;
    width: 100%;
    height: 100%;
    background-color: #ababab;
    z-index: 1001;
    -moz-opacity: 0.8;
    opacity: .70;
    filter: alpha(opacity=80);
}

#modal {
    display: none;
    position: absolute;
    top: 45%;
    left: 45%;
    width: 64px;
    height: 64px;
    padding:10px 5px 0px;
    border: 3px solid #ababab;
    box-shadow:1px 1px 10px #ababab;
    border-radius:20px;
    background-color: white;
    z-index: 1002;
    text-align:center;
}

</style>
</head>

<body>

<?php include'includes/header.php'; ?>

<div class="container">

  <div class="content">

    <div class="content-container">



      <div class="content-header">
        <h2 class="content-header-title">Tickets</h2>
        <ol class="breadcrumb">
          <li><a href="./">Home</a></li>
          <li class="active">Tickets</li>
        </ol>
      </div> <!-- /.content-header -->



      <div class="row">

		 <div class="col-md-12">
			<?php echo $addTicket; ?>
		 </div>

		<div class="col-md-12">

		 <div class="portlet">

            <div class="portlet-header">

              <h3>
                <i class="fa fa-ticket"></i>
                Tickets
              </h3>

			   <ul class="portlet-tools pull-right">
                <li>
                  <a data-toggle="modal" href="#basicModal" class="btn btn-sm btn-default">
                    Open Ticket
                  </a>
                </li>
              </ul>

            </div> <!-- /.portlet-header -->

            <div class="portlet-content">

            <div class="table-responsive">
				<?php
					if(in_array("all_ticket",$privileges)) {
						$Process->getallTickets();
					}elseif(in_array("station_ticket",$privileges)) {
						$Process->getStationTickets($_SESSION['station_id']);
					}elseif(in_array("user_ticket",$privileges)) {
						$Process->getUserTickets($_SESSION['userid']);
					}
				?>
            </div> <!-- /.table-responsive -->


            </div> <!-- /.portlet-content -->

          </div> <!-- /.portlet -->


        </div> <!-- /.col -->
		  <?php if(in_array("all_ticket",$privileges)): ?>
		<div class="col-md-12">
		 <div class="portlet">
            <div class="portlet-header">
              <h3>
                <i class="fa fa-th"></i>
                Ticket Search
              </h3>
            </div> <!-- /.portlet-header -->
            <div class="portlet-content">
				<form name="serchTicket" id="serchTicket" method="get">
				<table class="table table-striped table-bordered table-hover" >
					<tbody>
						<tr>

						  <td>
							<select class="form-control" name="station_id" id="station_id">
								<option value="All">--Station--</option>
								<?php $Process->listStation(); ?>
							</select>
						  </td>

						  <td>
							<div id="dp-ex-2" class="input-group date">
								<input class="form-control" name="startDate" type="text" placeholder="Start Date">
								<span class="input-group-addon"><i class="fa fa-calendar"></i></span>
							</div>
							<span class="help-block">yyyy-mm-dd</span>
						  </td>
						  <td>
							<div id="dp-ex-3" class="input-group date">
								<input class="form-control" name="endDate" type="text" placeholder="End Date">
								<span class="input-group-addon"><i class="fa fa-calendar"></i></span>
							</div>
							<span class="help-block">yyyy-mm-dd</span>
						  </td>
						  <td>
							<select class="form-control" name="severity">
								<option value="All">-- severity --</option>
								<option value="Low Level">Low Level</option>
								<option value="Normal Level">Normal Level</option>
								<option value="High Level">High Level</option>
							</select>
						  </td>
						  <td>
							<select class="form-control" name="tstatus">
								<option value="All">-- status --</option>
								<option value="Open">Open</option>
								<option value="Closed">Closed</option>
							</select>
						  </td>
						  <td>
							<select class="form-control" name="assigned">
								<option value="All">--Assign to--</option>
								<?php $Process->canBeAssigned("assign_ticket"); ?>
							</select>
						  </td>
						  <td>
							<button type="button" name="run_report" onclick="runTicketReport()" class="btn btn-primary">Run</button>
						  </td>
						</tr>
					</tbody>
				</table>
				</form>

				<div id="SearchResults"><!-- Results are displayed here --></div>
				<div id="fade"></div>
				<div id="modal">
					<img id="loader" src="img/loading.gif" />
				</div>


            </div> <!-- /.portlet-content -->

          </div> <!-- /.portlet -->


        </div> <!-- /.col -->
		 <?php endif; ?>
      </div> <!-- /.row -->

    </div> <!-- /.content-container -->

  </div> <!-- /.content -->

</div> <!-- /.container -->
	<?php include"includes/footer.php"; ?>

<div id="basicModal" class="modal fade">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3 class="modal-title"><i class="fa fa-ticket"></i> New Ticket</h3>
      </div>
	  <form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="post">
		<div class="modal-body">
			<div class="row">
				<div class="col-sm-12">
				<div class="form-group col-sm-12">
					<label for="subject">Ticket Subject</label>
					<input type="text" id="subject" name="subject" class="form-control" required>
				</div>
				</div> <!-- /.col -->
				<div class="col-sm-12">
					<div class="form-group col-sm-12">
						<label for="severity">Severity Level</label>
						<select class="form-control" name="severity" required>
							<option value="">--select severity level--</option>
							<option value="Low Level">Low Level</option>
							<option value="Normal Level">Normal Level</option>
							<option value="High Level">High Level</option>
						</select>
					</div>
				</div>
				<div class="col-sm-12">
					<div class="form-group col-sm-12">
						<label for="message">Description</label>
						<textarea name="message" rows="10" class="form-control" required></textarea>
					</div>
				</div>

        <?php if(in_array("assign_ticket",$_SESSION['privileges'])): ?>
  				<div class="col-sm-12">
  					<div class="form-group col-sm-12">
  						<label for="owner">Opened for</label>
  						<select class="form-control" name="owner" required>
  							<option value="">--Owner--</option>
  							<?php $Process->listEmployee(); ?>
  						</select>
  					</div>
  				</div>
        <?php endif; ?>
        <?php if(in_array("assign_ticket",$_SESSION['privileges'])): ?>
				<div class="col-sm-12">
					<div class="form-group col-sm-12">
						<label for="station">Station</label>
						<select class="form-control" name="station" required>
							<option value="">--station--</option>
							<?php $Process->listStation(); ?>
						</select>
					</div>
				</div>
      <?php endif; ?>
      <?php if(in_array("assign_ticket",$_SESSION['privileges'])): ?>
				<div class="col-sm-12">
					<div class="form-group col-sm-12">
						<label for="assigned">Assign To</label>
						<select class="form-control" name="assigned" required>
							<option value="">--Assign to--</option>
							<?php $Process->canBeAssigned("assign_ticket"); ?>
						</select>
					</div>
				</div>
      <?php endif; ?>

				</div> <!-- /.col -->

			</div>
		<div class="modal-footer">
			<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
			<button type="submit" name="open_ticket" class="btn btn-primary">Open Ticket</button>
		</div>
    </div><!-- /.modal-content -->
	 </form>
  </div><!-- /.modal-dialog -->
</div><!-- /.modal -->


 <script src="./js/libs/jquery-1.10.1.min.js"></script>
  <script src="./js/libs/jquery-ui-1.9.2.custom.min.js"></script>
  <script src="./js/libs/bootstrap.min.js"></script>

  <!--[if lt IE 9]>
  <script src="./js/libs/excanvas.compiled.js"></script>
  <![endif]-->

  <!-- Plugin JS -->
  <script src="./js/plugins/datatables/jquery.dataTables.min.js"></script>
  <script src="./js/plugins/datatables/DT_bootstrap.js"></script>
  <script src="./js/plugins/tableCheckable/jquery.tableCheckable.js"></script>
  <script src="./js/plugins/icheck/jquery.icheck.min.js"></script>
  <script src="./js/plugins/select2/select2.js"></script>
  <script src="./js/plugins/datepicker/bootstrap-datepicker.js"></script>
  <script src="./js/plugins/timepicker/bootstrap-timepicker.js"></script>

  <!-- App JS -->
  <script src="./js/target-admin.js"></script>
  <!-- Plugin JS -->
  <script src="./js/demos/form-extended.js"></script>

</body>
</html>
