<?php
include_once 'includes/processes.php';
$Process = new Login_Process;
$pageLink = basename($_SERVER['REQUEST_URI']);
$Process->check_status($pageLink);
$addComment = $Process->addComment($_POST,$_POST['save_comment']);
$assignTicket = $Process->assignTicket($_POST,$_POST['assign_ticket']);
$changeTicketStatus = $Process->changeTicketStatus($_POST,$_POST['change_status']);

$ticketData = $Process->getTicketInfo($_GET['tid']);
$empData = $Process->getEmployeeInfo($ticketData->assigned);
$empName = $empData->firstname." ".$empData->lastname;

$ownerData = $Process->getEmployeeInfo($ticketData->created_by);
$ownerName = $ownerData->firstname." ".$ownerData->lastname;
?>
<!DOCTYPE html>
<!--[if lt IE 7]>      <html class="no-js lt-ie9 lt-ie8 lt-ie7"> <![endif]-->
<!--[if IE 7]>         <html class="no-js lt-ie9 lt-ie8"> <![endif]-->
<!--[if IE 8]>         <html class="no-js lt-ie9"> <![endif]-->
<!--[if gt IE 8]><!--> <html class="no-js"> <!--<![endif]-->
<head>
  <title>Ticket Details [<?php echo "ATT".$ticketData->ticket_ref."-"; ?>
				<?php switch($ticketData->severity) {
							case "Low Level":
							echo"0";
							break;
							case "Normal Level":
							echo"1";
							break;
							case "High Level":
							echo"2";
							break;
						}
				?>] - APL Portal</title>

  <meta charset="utf-8">
  <meta name="description" content="">
  <meta name="viewport" content="width=device-width">

  <link rel="stylesheet" href="http://fonts.googleapis.com/css?family=Open+Sans:400italic,600italic,700italic,400,600,700">
  <link rel="stylesheet" href="http://fonts.googleapis.com/css?family=Oswald:400,300,700">
  <link rel="stylesheet" href="./css/font-awesome.min.css">
  <link rel="stylesheet" href="./js/libs/css/ui-lightness/jquery-ui-1.9.2.custom.min.css">
  <link rel="stylesheet" href="./css/bootstrap.min.css">

    <!-- App CSS -->
  <link rel="stylesheet" href="./css/target-admin.css">
  <link rel="stylesheet" href="./css/custom.css">

	<!--- <script src="https://cloud.tinymce.com/stable/tinymce.min.js"></script>
	<script>tinymce.init({ selector:'textarea' });</script> -->
  <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!--[if lt IE 9]>
  <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
  <script src="https://oss.maxcdn.com/libs/respond.js/1.3.0/respond.min.js"></script>
  <![endif]-->

</head>

<body>

  <?php include'includes/header.php'; ?>

<div class="container">

  <div class="content">

    <div class="content-container">



       <div class="content-header">
        <h2 class="content-header-title">Ticket Details</h2>
        <ol class="breadcrumb">
          <li><a href="./">Home</a></li>
          <li><a href="tickets.php">Tickets</a></li>
          <li class="active"><?php echo $ticketData->ticket_subject; ?> - <?php echo "ATT".$ticketData->ticket_ref."-"; ?>
				<?php switch($ticketData->severity) {
							case "Low Level":
							echo"0";
							break;
							case "Normal Level":
							echo"1";
							break;
							case "High Level":
							echo"2";
							break;
						}
				?> [<?php echo $empName; ?>]</li>
        </ol>
      </div> <!-- /.content-header -->



      <div class="row">

        <div class="col-md-12">
			<?php echo $changeTicketStatus; ?>
			<?php echo $assignTicket; ?>
		</div>

        <div class="col-md-8">

          <h3>Ticket Description
            <small class="pull-right">
          <strong>Date Opened:</strong> <?php echo date("M d, Y: h:ma",$ticketData->time_created); ?>
          | <strong>Owner:</strong> <?php echo $ownerName; ?>
        </small>
        </h3>

          <hr />

          <?php echo $ticketData->ticket_desc; ?>
          <br />
          <br />

          <h3>Comments</h3>

          <br />
		  <?php echo $addComment; ?>
          <br />
          <?php $Process->getTicketComments($_GET['tid']); ?>

		  <?php if($ticketData->status!="Closed"): ?>
		 <div class="portlet">
		 <form action="<?php echo $_SERVER['PHP_SELF']; ?>?tid=<?php echo $_GET['tid']; ?>" method="post">
			<input type="hidden" id="ticket_id" name="ticket_id" value="<?php echo $_GET['tid']; ?>" required>
            <div class="portlet-header">
              <h3>
                <i class="fa fa-comment"></i>
                Your Comment
              </h3>
            </div> <!-- /.portlet-header -->
            <div class="portlet-content">
				<div class="col-sm-12">
				  <textarea name="comment" rows="10" class="form-control" placeholder="Your Comment" required></textarea>
				</div> <!-- /.col -->
            </div> <!-- /.portlet-content -->
			<div class="portlet-footer">
				<button type="submit" name="save_comment" class="btn btn-primary">Save Comment</button>
            </div> <!-- /.portlet-footer -->
			</form>
          </div> <!-- /.portlet -->
		  <?php endif; ?>



        </div> <!-- /.col -->


        <div class="col-md-4 col-sidebar-right">

          <p><a href="javascript:;" class="btn btn-lg
			<?php if($ticketData->status=="Closed") { echo" btn-success"; }elseif($ticketData->status=="Open"){ echo" btn-danger"; }elseif($ticketData->status=="In Progress"){ echo" btn-warning"; } ?>
		  btn-block"><?php echo $ticketData->status; ?> Ticket</a></p>


          <p><a href="javascript:;" class="btn btn-jumbo
			<?php
				switch($ticketData->severity) {
					case "Low Level":
					echo"btn-info";
					break;
					case "Normal Level":
					echo"btn-warning";
					break;
					case "High Level":
					echo"btn-danger";
					break;
				}
			?>
		  btn btn-block"> <?php echo $ticketData->severity; ?> <br /></a></p>

          <br />

			<form action="<?php echo $_SERVER['PHP_SELF']; ?>?tid=<?php echo $_GET['tid']; ?>" method="post">
			<input type="hidden" id="tid" name="tid" value="<?php echo $_GET['tid']; ?>">
		    <?php if(in_array("close_ticket",$_SESSION['privileges']) || in_array("reopen_ticket",$_SESSION['privileges'])): ?>
			<h4>Ticket Actions</h4>
			<hr />

            <div class="list-group">
			<?php if($ticketData->status!="Closed"): ?>
				<?php if(in_array("close_ticket",$_SESSION['privileges'])): ?>
				<input type="hidden" id="status_val" name="status_val" value="0">
				  <button type="submit" name="change_status" onclick="return confirm('Are sure you want to close this Ticket?');" class="list-group-item">
					<i class="fa fa-power-off"></i>
					&nbsp;&nbsp;<strong>Close</strong> Ticket
				  </button>
				<?php endif; ?>
			  <?php else: ?>
				<?php if(in_array("reopen_ticket",$_SESSION['privileges'])): ?>
				<input type="hidden" id="status_val" name="status_val" value="1">
				 <button type="submit" name="change_status" onclick="return confirm('Are sure you want to re-open this Ticket?');" class="list-group-item">
					<i class="fa fa-power-off"></i>
					&nbsp;&nbsp;<strong>Re-open</strong> Ticket
				  </button>
				<?php endif; ?>
			  <?php endif; ?>
			  </div>
			  <?php endif; ?>
				</form>
			  <br />

			<?php if(in_array("assign_ticket",$_SESSION['privileges'])): ?>
            <?php if($ticketData->status!="Closed"): ?>
              <h4>Assign Ticket</h4>
              <hr />
              <div class="list-group">
        				<form action="<?php echo $_SERVER['PHP_SELF']; ?>?tid=<?php echo $_GET['tid']; ?>" method="post">
        					<input type="hidden" id="ticket_id" name="ticket_id" value="<?php echo $_GET['tid']; ?>" required>
        					<div class="form-group">
        						<div class="input-group">
        							<select class="form-control" name="assigned" required >
        								<option value="">--Assign to--</option>
        								<?php $Process->canBeAssigned("assigned_ticket",$empData->id); ?>
        							</select>
        							<span class="input-group-btn">
        								<button class="btn btn-primary" type="submit" name="assign_ticket">Assign</button>
        							</span>
        						</div>
        					</div>
        				</form>
              </div>
            <?php endif; ?>
			<?php endif; ?>

			<?php
				if(in_array("assign_ticket",$_SESSION['privileges'])){
					$Process->getTicketAssignmentHistory($_GET['tid']);
				}
			?>
			</div>
      </div> <!-- /.row -->

    </div> <!-- /.content-container -->

  </div> <!-- /.content -->

</div> <!-- /.container -->

<?php include"includes/footer.php"; ?>

</html>
