<?php
include_once 'includes/processes.php';
$Process = new Login_Process;

$pageLink = basename($_SERVER['REQUEST_URI']);
$Process->check_status($pageLink);

$employeeData = $Process->getEmployeeInfo($_SESSION['userid']);
$addTicket = $Process->addTicket($_POST,$_POST['open_ticket']);
$deptData = $Process->getDepartmentInfo($employeeData->department);
$desigData = $Process->getDesignationInfo($employeeData->designation);
?>
<!DOCTYPE html>
<!--[if lt IE 7]>      <html class="no-js lt-ie9 lt-ie8 lt-ie7"> <![endif]-->
<!--[if IE 7]>         <html class="no-js lt-ie9 lt-ie8"> <![endif]-->
<!--[if IE 8]>         <html class="no-js lt-ie9"> <![endif]-->
<!--[if gt IE 8]><!--> <html class="no-js"> <!--<![endif]-->
<head>
  <title>Dashboard - Airpeace Portal</title>

  <meta charset="utf-8">
  <meta name="description" content="">
  <meta name="viewport" content="width=device-width">

  <link rel="stylesheet" href="http://fonts.googleapis.com/css?family=Open+Sans:400italic,600italic,700italic,400,600,700">
  <link rel="stylesheet" href="http://fonts.googleapis.com/css?family=Oswald:400,300,700">
  <link rel="stylesheet" href="./css/font-awesome.min.css">
  <link rel="stylesheet" href="./js/libs/css/ui-lightness/jquery-ui-1.9.2.custom.min.css">
  <link rel="stylesheet" href="./css/bootstrap.min.css">

  <!-- Plugin CSS -->
  <link rel="stylesheet" href="./js/plugins/magnific/magnific-popup.css">

  <!-- App CSS -->
  <link rel="stylesheet" href="./css/target-admin.css">
  <link rel="stylesheet" href="./css/custom.css">


  <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!--[if lt IE 9]>
  <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
  <script src="https://oss.maxcdn.com/libs/respond.js/1.3.0/respond.min.js"></script>
  <![endif]-->

<script>
function startTime() {
    var today = new Date();
    var h = today.getHours();
    var m = today.getMinutes();
    var s = today.getSeconds();
    m = checkTime(m);
    s = checkTime(s);
    document.getElementById('timetxt').innerHTML = h + ":" + m + ":" + s;
    var t = setTimeout(startTime, 500);
}
function checkTime(i) {
    if (i < 10) {i = "0" + i};  // add zero in front of numbers < 10
    return i;
}
</script>
</head>

<body>

<?php include'includes/header.php'; ?>

<div class="container">

  <div class="content">

    <div class="content-container">
      <div>
        <h4 class="heading-inline">Hi <?php echo $_SESSION['username']; ?>
        &nbsp;&nbsp;<small>Today's date is <?php echo date("D d, M, Y",time()); ?> <div id="timetxt"></div></small>
        &nbsp;&nbsp;</h4>
      </div>

      <br>
	<?php if(in_array("all_ticket",$privileges)): ?>
      <div class="row">

        <div class="col-sm-6 col-md-3">
          <div class="row-stat">
            <p class="row-stat-label">Trouble Tickets</p>
            <h3 class="row-stat-value"><?php echo $Process->countTicket(); ?></h3>
            <a href="#" class="label label-success row-stat-badge" title="Closed Tickets"><?php echo $Process->countClosedTickets(); ?></a>
            <a href="#" class="label label-danger row-stat-badge" title="Open Tickets"><?php echo $Process->countOpenTickets(); ?></a>
          </div> <!-- /.row-stat -->
        </div> <!-- /.col -->


      </div> <!-- /.row -->
		<?php endif; ?>

      <br>



    <div class="row">

        <div class="col-md-12">
			<?php if(in_array("all_ticket",$_SESSION['privileges'])): ?>
         <div class="portlet portlet-table">

            <div class="portlet-header">

              <h3>
                <i class="fa fa-ticket"></i>
                Opened Tickets
              </h3>

              <ul class="portlet-tools pull-right">
                <li>
                  <a href="tickets.php" class="btn btn-sm btn-primary">
                    View All
                  </a>
                </li>
              </ul>

            </div> <!-- /.portlet-header -->
			<?php echo $addTicket; ?>
            <?php $Process->getOpenTickets(); ?>

          </div> <!-- /.portlet -->
		  <?php else: ?>
			<h3>Welcome to Airpeace Portal</h3><br />

			Please use the Menu on top to navigate through the portal.

		  <?php endif; ?>

		</div> <!-- /.col -->




	</div> <!-- /.content -->

</div> <!-- /.container -->


<?php include"includes/footer.php"; ?>

  <script src="./js/libs/jquery-1.10.1.min.js"></script>
  <script src="./js/libs/jquery-ui-1.9.2.custom.min.js"></script>
  <script src="./js/libs/bootstrap.min.js"></script>

  <!--[if lt IE 9]>
  <script src="./js/libs/excanvas.compiled.js"></script>
  <![endif]-->

  <!-- Plugin JS -->
  <script src="./js/plugins/magnific/jquery.magnific-popup.min.js"></script>

  <!-- App JS -->
  <script src="./js/target-admin.js"></script>




</body>

</html>
